CREATE OR REPLACE FUNCTION addColumn() RETURNS VOID AS $BODY$
BEGIN
    IF EXISTS (SELECT 1 FROM information_schema.columns
                    WHERE table_name= 'pdv_identifica_paf'
                         and column_name='data_emissao_laudo') THEN

        RAISE NOTICE 'Coluna "data_emissao_laudo" na tabela "pdv_identifica_paf" ja existe!' ;

    ELSE
        ALTER TABLE public.pdv_identifica_paf   ADD COLUMN data_emissao_laudo date;
        RAISE NOTICE 'Coluna "data_emissao_laudo" criada com sucesso!';
    END IF;

END;
-- fim bloco principal
$BODY$ LANGUAGE PLPGSQL VOLATILE COST 100;


ALTER FUNCTION addColumn() OWNER TO postgres;
SELECT addColumn();
DROP FUNCTION addColumn();